package ga.core.individual;

import ga.core.validation.GAContext;

/**
 * Interface for a individual factory. Genetic algorithms need to create new
 * individuals but can not call a specific constructor, since the concrete class
 * of the individual is unknown. The factory creates new individuals.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IIndividualFactory<T extends IIndividual<T>> {
  /**
   * Creates a new individual in the given context.
   * 
   * @param context
   *          The context.
   * @return The new individual.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public T newIndividual(GAContext context);

}
